<?php
// Eğer session henüz başlatılmamışsa başlat
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Admin girişi kontrol
if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Misafir kontrolü - POST, DELETE, PUT isteklerini engelle
if(isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'misafir') {
    // Form gönderme işlemlerini engelle
    if($_SERVER['REQUEST_METHOD'] != 'GET') {
        // POST varsa form işlemlerini bypass et
        $_POST = array();
        $_FILES = array();
        
        echo '<div class="alert alert-warning mt-3">
                <strong>Uyarı!</strong> Misafir hesabıyla değişiklik yapamazsınız.
                Bu panel sadece inceleme amaçlıdır.
              </div>';
        
        // Ana sayfaya veya mevcut sayfaya GET isteği ile yönlendir
        echo '<script>
                setTimeout(function() {
                    window.location.href = "' . basename($_SERVER['PHP_SELF']) . '";
                }, 2000);
              </script>';
        exit;
    }
}

// Sayfa sonunda eklenecek JavaScript için buffer başlat
ob_start();

// Sayfa sonunda eklenecek JavaScript
register_shutdown_function(function() {
    $content = ob_get_clean();
    
    // Misafir kullanıcı için JavaScript ekle
    if(isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'misafir') {
        $js_code = <<<EOT
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Tüm formları seç ve submit olayını engelle
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Misafir hesabıyla değişiklik yapamazsınız!');
            return false;
        });
    });
    
    // Add ve Delete butonlarını etkisiz hale getir
    const actionButtons = document.querySelectorAll('a.btn-danger, a.btn-primary:not(.nav-link), button.btn-primary[type="submit"], button.btn-danger');
    actionButtons.forEach(button => {
        button.classList.remove('btn-primary', 'btn-danger');
        button.classList.add('btn-secondary');
        button.setAttribute('disabled', 'disabled');
        
        // href'i olan butonlar için onclick olay dinleyicisi ekle
        if(button.hasAttribute('href')) {
            const originalHref = button.getAttribute('href');
            button.removeAttribute('href');
            button.style.cursor = 'not-allowed';
            button.setAttribute('data-original-href', originalHref);
            button.addEventListener('click', function(e) {
                e.preventDefault();
                alert('Misafir hesabıyla bu işlemi yapamazsınız!');
                return false;
            });
        }
    });
    
    // Bilgilendirme mesajı
    const contentArea = document.getElementById('contentArea') || document.querySelector('.content') || document.body;
    const infoAlert = document.createElement('div');
    infoAlert.className = 'alert alert-info mb-4';
    infoAlert.innerHTML = '<strong>Bilgi:</strong> Misafir hesabı kullanıyorsunuz. Bu panelde sadece inceleme yapabilirsiniz.';
    
    // Mesajı başa ekle
    if(contentArea.firstChild) {
        contentArea.insertBefore(infoAlert, contentArea.firstChild);
    } else {
        contentArea.appendChild(infoAlert);
    }
});
</script>
EOT;
        
        // JavaScript kodunu </body> etiketinden önce ekle
        echo str_replace('</body>', $js_code . '</body>', $content);
    } else {
        echo $content;
    }
});
?>