<?php
require_once 'auth.php';
require_once '../config/db.php';
session_start();

if(!isset($_SESSION['admin'])) {
    die(json_encode(['error' => 'Unauthorized']));
}

$days = isset($_GET['days']) ? intval($_GET['days']) : 7;

try {
    $dates = [];
    $visitors = [];
    
    for($i = $days - 1; $i >= 0; $i--) {
        $date = date('Y-m-d', strtotime("-$i days"));
        $dates[] = date('d.m', strtotime($date));
        
        // O gün için benzersiz ziyaretçi sayısını al
        $stmt = $conn->prepare("SELECT COUNT(DISTINCT ip_adresi) FROM site_ziyaretleri WHERE DATE(tarih) = ?");
        $stmt->execute([$date]);
        $visitors[] = (int)$stmt->fetchColumn();
    }
    
    // Toplam benzersiz ziyaretçi sayısını al
    $total_visitors = $conn->query("SELECT COUNT(DISTINCT ip_adresi) FROM site_ziyaretleri")->fetchColumn();
    $today_visitors = $conn->query("SELECT COUNT(DISTINCT ip_adresi) FROM site_ziyaretleri WHERE DATE(tarih) = CURDATE()")->fetchColumn();
    
    echo json_encode([
        'dates' => $dates,
        'visitors' => $visitors,
        'totals' => [
            'total_visitors' => (int)$total_visitors,
            'today_visitors' => (int)$today_visitors
        ]
    ]);
    
} catch(PDOException $e) {
    echo json_encode([
        'error' => $e->getMessage(),
        'sql_state' => $e->getCode()
    ]);
} 