<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Paneli - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        .card-counter {
            padding: 20px;
            margin-bottom: 20px;
            border-radius: 5px;
            color: white;
        }
        .primary {
            background: #007bff;
        }
        .danger {
            background: #dc3545;
        }
        .success {
            background: #28a745;
        }
        .card {
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            border: none;
            margin-bottom: 1rem;
        }
        
        .card-title {
            color: #333;
            font-size: 1rem;
            font-weight: 600;
            margin-bottom: 1.25rem;
        }
        
        .form-select-sm {
            font-size: 0.875rem;
            padding: 0.25rem 2rem 0.25rem 0.5rem;
        }
        
        .h-100 {
            height: 100%!important;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            .content {
                margin-left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Genel Bakış</h2>
                <div class="row">
                    <div class="col-md-4">
                        <div class="card-counter primary">
                            <i class="fas fa-list fa-3x"></i>
                            <h3>Kategoriler</h3>
                            <?php
                            $stmt = $conn->query("SELECT COUNT(*) as total FROM kategoriler");
                            $kategori_sayisi = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                            ?>
                            <span class="count"><?php echo $kategori_sayisi; ?></span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card-counter success">
                            <i class="fas fa-utensils fa-3x"></i>
                            <h3>Ürünler</h3>
                            <?php
                            $stmt = $conn->query("SELECT COUNT(*) as total FROM urunler");
                            $urun_sayisi = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                            ?>
                            <span class="count"><?php echo $urun_sayisi; ?></span>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card-counter danger">
                            <i class="fas fa-comment-alt fa-3x"></i>
                            <h3>Şikayetler</h3>
                            <?php
                            $stmt = $conn->query("SELECT COUNT(*) as total FROM sikayetler WHERE okundu = 0");
                            $sikayet_sayisi = $stmt->fetch(PDO::FETCH_ASSOC)['total'];
                            ?>
                            <span class="count"><?php echo $sikayet_sayisi; ?></span>
                        </div>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-md-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Ürün Değerlendirmeleri</h5>
                                <div class="d-flex justify-content-end mb-3">
                                    <select id="ratingDateRange" class="form-select form-select-sm" style="width: auto;">
                                        <option value="7">Son 7 Gün</option>
                                        <option value="30">Son 30 Gün</option>
                                        <option value="90">Son 3 Ay</option>
                                    </select>
                                </div>
                                <canvas id="ratingChart"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Şikayetler</h5>
                                <div class="d-flex justify-content-end mb-3">
                                    <select id="complaintsDateRange" class="form-select form-select-sm" style="width: auto;">
                                        <option value="7">Son 7 Gün</option>
                                        <option value="30">Son 30 Gün</option>
                                        <option value="90">Son 3 Ay</option>
                                    </select>
                                </div>
                                <canvas id="complaintsChart"></canvas>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card h-100">
                            <div class="card-body">
                                <h5 class="card-title">Site Ziyaretçileri</h5>
                                <div class="d-flex justify-content-end mb-3">
                                    <select id="feedbackDateRange" class="form-select form-select-sm" style="width: auto;">
                                        <option value="7">Son 7 Gün</option>
                                        <option value="30">Son 30 Gün</option>
                                        <option value="90">Son 3 Ay</option>
                                    </select>
                                </div>
                                <canvas id="feedbackChart"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script>
    let ratingChart;
    let complaintsChart;
    let visitorsChart;

    function fetchRatingData(days) {
        fetch(`./get_rating_stats.php?days=${days}`)
            .then(response => response.json())
            .then(data => {
                if (ratingChart) {
                    ratingChart.destroy();
                }

                const ctx = document.getElementById('ratingChart').getContext('2d');
                ratingChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: data.dates,
                        datasets: [
                            {
                                label: 'Beğeniler',
                                data: data.likes,
                                borderColor: '#28a745',
                                backgroundColor: 'rgba(40, 167, 69, 0.1)',
                                tension: 0.4
                            },
                            {
                                label: 'Beğenmemeler',
                                data: data.dislikes,
                                borderColor: '#dc3545',
                                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                                tension: 0.4
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'top',
                            },
                            title: {
                                display: true,
                                text: 'Günlük Ürün Değerlendirmeleri'
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                }
                            }
                        }
                    }
                });
            })
            .catch(error => console.error('Veri çekme hatası:', error));
    }

    function fetchComplaintsData(days) {
        fetch(`./get_complaints_stats.php?days=${days}`)
            .then(response => response.json())
            .then(data => {
                if (complaintsChart) {
                    complaintsChart.destroy();
                }

                const ctx = document.getElementById('complaintsChart').getContext('2d');
                complaintsChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: data.dates,
                        datasets: [
                            {
                                label: 'Şikayetler',
                                data: data.complaints,
                                borderColor: '#dc3545',
                                backgroundColor: 'rgba(220, 53, 69, 0.1)',
                                tension: 0.4
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'top',
                            },
                            title: {
                                display: true,
                                text: 'Günlük Şikayet Sayısı'
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                }
                            }
                        }
                    }
                });
            })
            .catch(error => console.error('Şikayet verisi çekme hatası:', error));
    }

    function fetchVisitorsData(days) {
        fetch(`./get_visitors_stats.php?days=${days}`)
            .then(response => response.json())
            .then(data => {
                if (visitorsChart) {
                    visitorsChart.destroy();
                }

                const ctx = document.getElementById('feedbackChart').getContext('2d');
                visitorsChart = new Chart(ctx, {
                    type: 'line',
                    data: {
                        labels: data.dates,
                        datasets: [
                            {
                                label: 'Ziyaretçiler',
                                data: data.visitors,
                                borderColor: '#17a2b8',
                                backgroundColor: 'rgba(23, 162, 184, 0.1)',
                                tension: 0.4
                            }
                        ]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: {
                                position: 'top',
                            },
                            title: {
                                display: true,
                                text: 'Günlük Ziyaretçi Sayısı'
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true,
                                ticks: {
                                    stepSize: 1
                                }
                            }
                        }
                    }
                });
            })
            .catch(error => console.error('Ziyaretçi verisi çekme hatası:', error));
    }

    document.addEventListener('DOMContentLoaded', function() {
        fetchRatingData(7);
        fetchComplaintsData(7);
        fetchVisitorsData(7);
        
        document.getElementById('ratingDateRange').addEventListener('change', function() {
            fetchRatingData(this.value);
        });
        
        document.getElementById('complaintsDateRange').addEventListener('change', function() {
            fetchComplaintsData(this.value);
        });
        
        document.getElementById('feedbackDateRange').addEventListener('change', function() {
            fetchVisitorsData(this.value);
        });
    });

    document.getElementById('sidebarToggle').addEventListener('click', function() {
        document.getElementById('sidebar').classList.toggle('show');
    });

    document.getElementById('sidebarClose').addEventListener('click', function() {
        document.getElementById('sidebar').classList.remove('show');
    });

    document.getElementById('contentArea').addEventListener('click', function(event) {
        if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
            document.getElementById('sidebar').classList.remove('show');
        }
    });
    </script>
</body>
</html> 