<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

if(!isset($_GET['id'])) {
    header("Location: kategoriler.php");
    exit;
}

$id = $_GET['id'];

// Kategori Güncelleme
if(isset($_POST['kategori_guncelle'])) {
    $kategori_adi = $_POST['kategori_adi'];
    
    // Resim yükleme
    if(isset($_FILES['kategori_resim']) && $_FILES['kategori_resim']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['kategori_resim']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            // Eski resimleri sil (hem jpg hem webp)
            $eski_resim_jpg = '../uploads/kategori_' . $id . '.jpg';
            $eski_resim_webp = '../uploads/kategori_' . $id . '.webp';
            if(file_exists($eski_resim_jpg)) {
                unlink($eski_resim_jpg);
            }
            if(file_exists($eski_resim_webp)) {
                unlink($eski_resim_webp);
            }
            
            $yeni_isim = 'kategori_' . $id;
            $hedef_yol = '../uploads/' . $yeni_isim;
            
            // GD kütüphanesi kontrolü
            if (!extension_loaded('gd')) {
                error_log('GD kütüphanesi yüklü değil!');
                // GD yoksa direkt orijinal dosyayı kaydet
                if(move_uploaded_file($_FILES['kategori_resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    error_log('GD olmadığı için orijinal dosya yüklendi: ' . $yeni_isim . '.' . $dosya_uzantisi);
                }
            } else {
                // Orijinal resmi yükle
                if(move_uploaded_file($_FILES['kategori_resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    error_log('Orijinal dosya başarıyla yüklendi: ' . $hedef_yol . '.' . $dosya_uzantisi);
                    
                    // WebP'ye dönüştür
                    $kaynak_resim = null;
                    
                    // Kaynak resmi yükle
                    if($dosya_uzantisi == 'jpg' || $dosya_uzantisi == 'jpeg') {
                        $kaynak_resim = @imagecreatefromjpeg($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('JPEG/JPG dosyası yükleme denemesi');
                    } else if($dosya_uzantisi == 'png') {
                        $kaynak_resim = @imagecreatefrompng($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('PNG dosyası yükleme denemesi');
                    }
                    
                    if($kaynak_resim) {
                        error_log('Kaynak resim başarıyla oluşturuldu');
                        // WebP olarak kaydet
                        if(imagewebp($kaynak_resim, $hedef_yol . '.webp', 80)) {
                            error_log('WebP dönüşümü başarılı: ' . $hedef_yol . '.webp');
                            
                            // Belleği temizle
                            imagedestroy($kaynak_resim);
                            
                            // Orijinal dosyayı sil
                            if(unlink($hedef_yol . '.' . $dosya_uzantisi)) {
                                error_log('Orijinal dosya silindi');
                            } else {
                                error_log('Orijinal dosya silinemedi');
                            }
                        } else {
                            error_log('WebP dönüşümü başarısız. PHP hatası: ' . error_get_last()['message']);
                        }
                    } else {
                        error_log('Kaynak resim oluşturulamadı. PHP hatası: ' . error_get_last()['message']);
                    }
                } else {
                    error_log('Dosya yükleme hatası: ' . error_get_last()['message']);
                }
            }
        }
    }
    
    $stmt = $conn->prepare("UPDATE kategoriler SET kategori_adi = ? WHERE id = ?");
    $stmt->execute([$kategori_adi, $id]);
    header("Location: kategoriler.php?mesaj=guncellendi");
}

// Kategori bilgilerini al
$stmt = $conn->prepare("SELECT * FROM kategoriler WHERE id = ?");
$stmt->execute([$id]);
$kategori = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$kategori) {
    header("Location: kategoriler.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kategori Düzenle - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        .kategori-resim {
            max-width: 200px;
            max-height: 200px;
            object-fit: cover;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Kategori Düzenle</h2>
                
                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="kategori_adi" class="form-label">Kategori Adı</label>
                                <input type="text" class="form-control" id="kategori_adi" name="kategori_adi" value="<?php echo $kategori['kategori_adi']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label for="kategori_resim" class="form-label">Kategori Resmi</label>
                                <?php
                                $resim_yolu_webp = '../uploads/kategori_' . $id . '.webp';
                                $resim_yolu_jpg = '../uploads/kategori_' . $id . '.jpg';
                                if(file_exists($resim_yolu_webp)):
                                ?>
                                <div class="mb-2">
                                    <img src="<?php echo $resim_yolu_webp; ?>" class="kategori-resim">
                                </div>
                                <?php elseif(file_exists($resim_yolu_jpg)): ?>
                                <div class="mb-2">
                                    <img src="<?php echo $resim_yolu_jpg; ?>" class="kategori-resim">
                                </div>
                                <?php endif; ?>
                                <input type="file" class="form-control" id="kategori_resim" name="kategori_resim" accept="image/jpeg,image/png">
                                <small class="text-muted">Yeni resim seçmezseniz mevcut resim korunacaktır. Önerilen boyut: 800x600 piksel</small>
                            </div>
                            <button type="submit" name="kategori_guncelle" class="btn btn-primary">Güncelle</button>
                            <a href="kategoriler.php" class="btn btn-secondary">İptal</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });
    });
    </script>
</body>
</html> 