<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    die(json_encode(['success' => false, 'message' => 'Yetkisiz erişim']));
}

$data = json_decode(file_get_contents('php://input'), true);
$kategori_ids = $data['kategori_ids'] ?? [];

if(empty($kategori_ids)) {
    die(json_encode(['success' => false, 'message' => 'Kategori seçilmedi']));
}

try {
    foreach($kategori_ids as $id) {
        // Kategoriyi sil
        $stmt = $conn->prepare("DELETE FROM kategoriler WHERE id = ?");
        $stmt->execute([$id]);
        
        // Resimleri sil (hem jpg hem webp)
        $resim_yolu_jpg = "../uploads/kategori_{$id}.jpg";
        $resim_yolu_webp = "../uploads/kategori_{$id}.webp";
        
        if(file_exists($resim_yolu_jpg)) {
            unlink($resim_yolu_jpg);
        }
        if(file_exists($resim_yolu_webp)) {
            unlink($resim_yolu_webp);
        }
    }
    
    echo json_encode(['success' => true]);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 