<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Kategori Ekleme
if(isset($_POST['kategori_ekle'])) {
    $kategori_adi = $_POST['kategori_adi'];
    $stmt = $conn->prepare("INSERT INTO kategoriler (kategori_adi) VALUES (?)");
    $stmt->execute([$kategori_adi]);
    $kategori_id = $conn->lastInsertId();

    // Resim yükleme
    if(isset($_FILES['kategori_resim']) && $_FILES['kategori_resim']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['kategori_resim']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            $yeni_isim = 'kategori_' . $kategori_id;
            $hedef_yol = '../uploads/' . $yeni_isim;
            
            // GD kütüphanesi kontrolü
            if (!extension_loaded('gd')) {
                error_log('GD kütüphanesi yüklü değil!');
                // GD yoksa direkt orijinal dosyayı kaydet
                if(move_uploaded_file($_FILES['kategori_resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    error_log('GD olmadığı için orijinal dosya yüklendi: ' . $yeni_isim . '.' . $dosya_uzantisi);
                }
            } else {
                // Orijinal resmi yükle
                if(move_uploaded_file($_FILES['kategori_resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                    error_log('Orijinal dosya başarıyla yüklendi: ' . $hedef_yol . '.' . $dosya_uzantisi);
                    
                    // WebP'ye dönüştür
                    $kaynak_resim = null;
                    
                    // Kaynak resmi yükle
                    if($dosya_uzantisi == 'jpg' || $dosya_uzantisi == 'jpeg') {
                        $kaynak_resim = @imagecreatefromjpeg($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('JPEG/JPG dosyası yükleme denemesi');
                    } else if($dosya_uzantisi == 'png') {
                        $kaynak_resim = @imagecreatefrompng($hedef_yol . '.' . $dosya_uzantisi);
                        error_log('PNG dosyası yükleme denemesi');
                    }
                    
                    if($kaynak_resim) {
                        error_log('Kaynak resim başarıyla oluşturuldu');
                        // WebP olarak kaydet
                        if(imagewebp($kaynak_resim, $hedef_yol . '.webp', 80)) {
                            error_log('WebP dönüşümü başarılı: ' . $hedef_yol . '.webp');
                            
                            // Belleği temizle
                            imagedestroy($kaynak_resim);
                            
                            // Orijinal dosyayı sil
                            if(unlink($hedef_yol . '.' . $dosya_uzantisi)) {
                                error_log('Orijinal dosya silindi');
                            } else {
                                error_log('Orijinal dosya silinemedi');
                            }
                        } else {
                            error_log('WebP dönüşümü başarısız. PHP hatası: ' . error_get_last()['message']);
                        }
                    } else {
                        error_log('Kaynak resim oluşturulamadı. PHP hatası: ' . error_get_last()['message']);
                    }
                } else {
                    error_log('Dosya yükleme hatası: ' . error_get_last()['message']);
                }
            }
        }
    }
    
    header("Location: kategoriler.php?mesaj=eklendi");
}

// Kategori Silme
if(isset($_GET['sil'])) {
    $id = $_GET['sil'];
    
    // Kategori resimlerini sil (hem jpg hem webp)
    $resim_yolu_jpg = '../uploads/kategori_' . $id . '.jpg';
    $resim_yolu_webp = '../uploads/kategori_' . $id . '.webp';
    
    if(file_exists($resim_yolu_jpg)) {
        unlink($resim_yolu_jpg);
    }
    if(file_exists($resim_yolu_webp)) {
        unlink($resim_yolu_webp);
    }
    
    $stmt = $conn->prepare("DELETE FROM kategoriler WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: kategoriler.php?mesaj=silindi");
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kategoriler - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
        .kategori-resim {
            max-width: 100px;
            max-height: 100px;
            object-fit: cover;
        }
        .collapse {
            transition: all 0.3s ease;
        }
        
        .btn-close {
            opacity: 0.5;
        }
        
        .btn-close:hover {
            opacity: 1;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Kategoriler</h2>
                
                <?php if(isset($_GET['mesaj'])): ?>
                    <?php if($_GET['mesaj'] == 'eklendi'): ?>
                        <div class="alert alert-success">Kategori başarıyla eklendi.</div>
                    <?php elseif($_GET['mesaj'] == 'silindi'): ?>
                        <div class="alert alert-success">Kategori başarıyla silindi.</div>
                    <?php endif; ?>
                <?php endif; ?>

                <!-- Yeni Kategori Ekleme Butonu -->
                <div class="mb-4">
                    <button class="btn btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#kategoriEkleForm">
                        <i class="fas fa-plus"></i> Yeni Kategori Ekle
                    </button>
                </div>

                <!-- Kategori Ekleme Formu (Collapse) -->
                <div class="collapse mb-4" id="kategoriEkleForm">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="card-title mb-0">Yeni Kategori Ekle</h5>
                                <button type="button" class="btn-close" data-bs-toggle="collapse" data-bs-target="#kategoriEkleForm"></button>
                            </div>
                            <form method="POST" action="" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label for="kategori_adi" class="form-label">Kategori Adı</label>
                                    <input type="text" class="form-control" id="kategori_adi" name="kategori_adi" required>
                                </div>
                                <div class="mb-3">
                                    <label for="kategori_resim" class="form-label">Kategori Resmi</label>
                                    <input type="file" class="form-control" id="kategori_resim" name="kategori_resim" accept="image/jpeg,image/png">
                                    <small class="text-muted">Önerilen boyut: 800x600 piksel</small>
                                </div>
                                <button type="submit" name="kategori_ekle" class="btn btn-primary">Ekle</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Toplu İşlem Butonları -->
                <div class="mb-3">
                    <button type="button" class="btn btn-danger" id="topluSilBtn" style="display: none;">
                        <i class="fas fa-trash"></i> Seçilenleri Sil
                    </button>
                </div>

                <!-- Kategoriler Listesi -->
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Mevcut Kategoriler</h5>
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="tumunuSec">
                                    </th>
                                    <th>ID</th>
                                    <th>Resim</th>
                                    <th>Kategori Adı</th>
                                    <th>İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY id DESC");
                                while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
                                ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" class="kategori-sec" value="<?php echo $kategori['id']; ?>">
                                    </td>
                                    <td><?php echo $kategori['id']; ?></td>
                                    <td>
                                        <?php
                                        $webp_path = '../uploads/kategori_' . $kategori['id'] . '.webp';
                                        $jpg_path = '../uploads/kategori_' . $kategori['id'] . '.jpg';
                                        $image_path = file_exists($webp_path) ? $webp_path : $jpg_path;
                                        ?>
                                        <img src="<?php echo $image_path; ?>" 
                                             onerror="this.src='../uploads/default_category.jpg'"
                                             class="kategori-resim" 
                                             alt="<?php echo $kategori['kategori_adi']; ?>">
                                    </td>
                                    <td><?php echo $kategori['kategori_adi']; ?></td>
                                    <td>
                                        <button type="button" class="btn btn-sm btn-info kopyalaBtn" 
                                                data-id="<?php echo $kategori['id']; ?>" 
                                                data-ad="<?php echo htmlspecialchars($kategori['kategori_adi']); ?>">
                                            <i class="fas fa-copy"></i> Kopyala
                                        </button>
                                        <a href="kategori_duzenle.php?id=<?php echo $kategori['id']; ?>" class="btn btn-sm btn-warning">
                                            <i class="fas fa-edit"></i> Düzenle
                                        </a>
                                        <a href="?sil=<?php echo $kategori['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu kategoriyi silmek istediğinizden emin misiniz?')">
                                            <i class="fas fa-trash"></i> Sil
                                        </a>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Kopyalama Modal -->
                <div class="modal fade" id="kopyalaModal" tabindex="-1">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Kategori Kopyala</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <form id="kopyalaForm" method="POST" action="kategori_kopyala.php">
                                    <input type="hidden" name="kaynak_id" id="kaynak_id">
                                    <div class="mb-3">
                                        <label for="yeni_ad" class="form-label">Yeni Kategori Adı</label>
                                        <input type="text" class="form-control" id="yeni_ad" name="yeni_ad" required>
                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                <button type="submit" form="kopyalaForm" class="btn btn-primary">Kopyala</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });

        // Toplu seçim işlemleri
        const tumunuSec = document.getElementById('tumunuSec');
        const kategoriCheckboxlar = document.querySelectorAll('.kategori-sec');
        const topluSilBtn = document.getElementById('topluSilBtn');
        
        tumunuSec.addEventListener('change', function() {
            kategoriCheckboxlar.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            topluSilBtn.style.display = this.checked ? 'inline-block' : 'none';
        });
        
        kategoriCheckboxlar.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const seciliSayisi = document.querySelectorAll('.kategori-sec:checked').length;
                topluSilBtn.style.display = seciliSayisi > 0 ? 'inline-block' : 'none';
                tumunuSec.checked = seciliSayisi === kategoriCheckboxlar.length;
            });
        });
        
        // Toplu silme işlemi
        topluSilBtn.addEventListener('click', function() {
            if(confirm('Seçili kategorileri silmek istediğinizden emin misiniz?')) {
                const seciliKategoriler = Array.from(document.querySelectorAll('.kategori-sec:checked'))
                                             .map(cb => cb.value);
                
                fetch('kategori_toplu_sil.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        kategori_ids: seciliKategoriler
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if(data.success) {
                        location.reload();
                    } else {
                        alert('Bir hata oluştu: ' + data.message);
                    }
                });
            }
        });
        
        // Kopyalama işlemleri
        const kopyalaModal = new bootstrap.Modal(document.getElementById('kopyalaModal'));
        
        document.querySelectorAll('.kopyalaBtn').forEach(btn => {
            btn.addEventListener('click', function() {
                const id = this.dataset.id;
                const ad = this.dataset.ad;
                
                document.getElementById('kaynak_id').value = id;
                document.getElementById('yeni_ad').value = ad + ' - Kopya';
                
                kopyalaModal.show();
            });
        });
        
        // URL'de mesaj parametresi varsa ve form açıksa, formu kapat
        if(window.location.search.includes('mesaj=') && document.querySelector('#kategoriEkleForm.show')) {
            const collapseForm = new bootstrap.Collapse(document.getElementById('kategoriEkleForm'));
            collapseForm.hide();
        }
    });
    </script>
</body>
</html> 