<?php
session_start();
require_once '../config/db.php';
if(isset($_POST['giris'])) {
    $kullanici_adi = $_POST['kullanici_adi'];
    $sifre = $_POST['sifre'];
    // Rol bilgisini de çek
    $stmt = $conn->prepare("SELECT *, rol FROM admin WHERE kullanici_adi = ? AND sifre = ?");
    $stmt->execute([$kullanici_adi, md5($sifre)]);
    if($stmt->rowCount() > 0) {
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        $_SESSION['admin'] = true;
        $_SESSION['user_role'] = $user['rol']; // Rol bilgisini sakla
        $_SESSION['username'] = $user['kullanici_adi'];
        header("Location: index.php");
    } else {
        $hata = "Kullanıcı adı veya şifre hatalı!";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Misafir Girişi - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-image: url('../uploads/arkaplan.jpg');
            background-size: cover; /* Arka planı kapla */
            background-position: center; /* Merkezde konumlandır */
            height: 100vh; /* Tam yükseklik */
            margin: 0; /* Varsayılan margin'i kaldır */
            display: flex; /* Flexbox kullanarak içerikleri ortala */
            align-items: center; /* Dikey ortala */
            justify-content: center; /* Yatay ortala */
        }
        .login-container {
            max-width: 400px;
            padding: 20px;
            background: rgba(255, 255, 255, 0.8); /* %30 şeffaf beyaz arka plan */
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="login-container">
            <h2 class="text-center mb-4">Misafir Girişi</h2>
            <?php if(isset($hata)): ?>
                <div class="alert alert-danger"><?php echo $hata; ?></div>
            <?php endif; ?>
            <form method="POST" action="">
                <div class="mb-3">
                    <label for="kullanici_adi" class="form-label">Kullanıcı Adı</label>
                    <input type="text" class="form-control" id="kullanici_adi" name="kullanici_adi" value="misafir" required>
                </div>
                <div class="mb-3">
                    <label for="sifre" class="form-label">Şifre</label>
                    <input type="password" class="form-control" id="sifre" name="sifre" value="misafir123" required>
                </div>
                <button type="submit" name="giris" class="btn btn-primary w-100">Misafir Olarak Giriş Yap</button>
            </form>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>