<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Masa Ekleme
if(isset($_POST['masa_ekle'])) {
    $masa_no = $_POST['masa_no'];
    $masa_adi = $_POST['masa_adi'] ?? '';
    $masa_aciklama = $_POST['masa_aciklama'] ?? '';
    
    // Benzersiz bir kod oluştur
    $benzersiz_kod = md5($masa_no . time());
    
    $stmt = $conn->prepare("INSERT INTO masalar (masa_no, masa_adi, masa_aciklama, benzersiz_kod, olusturma_tarihi) 
                           VALUES (?, ?, ?, ?, NOW())");
    $stmt->execute([$masa_no, $masa_adi, $masa_aciklama, $benzersiz_kod]);
    
    header("Location: qr.php?mesaj=eklendi");
}

// Masa Silme
if(isset($_GET['sil'])) {
    $id = $_GET['sil'];
    $stmt = $conn->prepare("DELETE FROM masalar WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: qr.php?mesaj=silindi");
}

// Masa Düzenleme
if(isset($_POST['masa_guncelle'])) {
    $id = $_POST['id'];
    $masa_no = $_POST['masa_no'];
    $masa_adi = $_POST['masa_adi'] ?? '';
    $masa_aciklama = $_POST['masa_aciklama'] ?? '';
    
    $stmt = $conn->prepare("UPDATE masalar SET masa_no = ?, masa_adi = ?, masa_aciklama = ? WHERE id = ?");
    $stmt->execute([$masa_no, $masa_adi, $masa_aciklama, $id]);
    
    header("Location: qr.php?mesaj=guncellendi");
}

// Arka plan resmi yükleme işlemi
if(isset($_POST['qr_arkaplan_yukle']) && isset($_FILES['qr_arkaplan'])) {
    if($_FILES['qr_arkaplan']['error'] == 0) {
        $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
        $dosya_uzantisi = strtolower(pathinfo($_FILES['qr_arkaplan']['name'], PATHINFO_EXTENSION));
        
        if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
            // Benzersiz bir dosya adı oluştur
            $benzersiz_isim = 'qr_arkaplan_' . time() . '.' . $dosya_uzantisi;
            
            // Yeni resmi kaydet
            move_uploaded_file($_FILES['qr_arkaplan']['tmp_name'], '../uploads/' . $benzersiz_isim);
            
            // Veritabanına kaydet
            $stmt = $conn->prepare("UPDATE ayarlar SET qr_arkaplan = ? WHERE id = 1");
            $stmt->execute([$benzersiz_isim]);
            
            header("Location: qr.php?mesaj=arkaplan_yuklendi");
            exit;
        }
    }
}

// Arkaplan resmi silme işlemi
if(isset($_POST['qr_arkaplan_sil'])) {
    // Mevcut arkaplan dosyasını bul ve sil
    $stmt = $conn->prepare("SELECT qr_arkaplan FROM ayarlar WHERE id = 1");
    $stmt->execute();
    $ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);
    $arkaplan_resmi = $ayarlar['qr_arkaplan'] ?? '';
    
    if(!empty($arkaplan_resmi) && file_exists('../uploads/'.$arkaplan_resmi)) {
        unlink('../uploads/'.$arkaplan_resmi);
    }
    
    // Veritabanında arkaplan değerini boşalt
    $stmt = $conn->prepare("UPDATE ayarlar SET qr_arkaplan = '' WHERE id = 1");
    $stmt->execute();
    
    header("Location: qr.php?mesaj=arkaplan_silindi");
    exit;
}

// Arka plan bilgisini getir
$stmt = $conn->prepare("SELECT qr_arkaplan FROM ayarlar WHERE id = 1");
$stmt->execute();
$ayarlar = $stmt->fetch(PDO::FETCH_ASSOC);
$arkaplan_resmi = isset($ayarlar['qr_arkaplan']) && !empty($ayarlar['qr_arkaplan']) ? $ayarlar['qr_arkaplan'] : '';
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Kodlar - QR Menü Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        .card {
            margin-bottom: 20px;
        }
        .qr-image {
            max-width: 200px;
            margin: 0 auto;
        }
        .masa-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            transition: all 0.3s ease;
        }
        .masa-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        .action-buttons {
            display: flex;
            gap: 5px;
        }
        .print-button {
            margin-top: 10px;
        }
        @media print {
            .no-print {
                display: none !important;
            }
            .print-only {
                display: block !important;
            }
            .container-fluid {
                width: 100% !important;
                max-width: none !important;
            }
        }
        .print-only {
            display: none;
        }
        .qr-container {
            position: relative;
            width: 100%;
            max-width: 300px;
            margin: 0 auto;
            padding: 20px;
            border-radius: 10px;
            background-color: white;
        }
        
        .qr-print-template {
            position: relative;
            width: 85mm; /* A7 boyutu genişlik */
            height: 118mm; /* A7 boyutu yükseklik */
            margin: 0 auto;
            background-size: cover;
            background-position: center;
            text-align: center;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            align-items: center;
            padding: 15mm 10mm;
            box-sizing: border-box;
        }
        
        .qr-title {
            font-size: 24px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10mm;
        }
        
        .qr-code-container {
            padding: 8px;
            background: white;
            border-radius: 8px;
            margin-bottom: 10mm;
        }
        
        .qr-footer {
            font-size: 12px;
            color: #333;
            text-align: center;
            font-weight: bold;
        }

        .qr-background-upload {
            margin-bottom: 20px;
            padding: 15px;
            border: 1px solid #ddd;
            border-radius: 8px;
            background: #f9f9f9;
        }
        
        @media print {
            body * {
                visibility: hidden;
            }
            .qr-print-template, .qr-print-template * {
                visibility: visible;
            }
            .qr-print-template {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                margin: 0;
                padding: 10mm;
            }
        }
        
        /* Şablonun ana sayfada görünmemesi için */
        .qr-print-template, .qr-item {
            display: none;
        }
        
        /* Sadece yazdırma penceresinde görünsün */
        .print-window .qr-print-template,
        .print-window .qr-item {
            display: flex;
        }
        
        @media print {
            /* Diğer print stilleri... */
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php" class="active"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">QR Kodlar</h2>
                
                <?php if(isset($_GET['mesaj'])): ?>
                <div class="alert alert-success alert-dismissible fade show no-print" role="alert">
                    <?php 
                    $mesaj = $_GET['mesaj'];
                    if($mesaj == 'eklendi') echo "Masa başarıyla eklendi.";
                    else if($mesaj == 'silindi') echo "Masa başarıyla silindi.";
                    else if($mesaj == 'guncellendi') echo "Masa başarıyla güncellendi.";
                    else if($mesaj == 'arkaplan_yuklendi') echo "QR kod arka plan görseli başarıyla yüklendi.";
                    else if($mesaj == 'arkaplan_silindi') echo "QR kod arka plan görseli başarıyla silindi.";
                    ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
                </div>
                <?php endif; ?>
                
                <!-- Arka Plan Yükleme Formu -->
                <div class="card mb-4 no-print">
                    <div class="card-header">
                        <h5>QR Kod Arka Plan Görseli</h5>
                    </div>
                    <div class="card-body">
                        <form action="" method="POST" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="qr_arkaplan" class="form-label">Arka Plan Seçin (JPG veya PNG)</label>
                                <input type="file" class="form-control" id="qr_arkaplan" name="qr_arkaplan" accept="image/jpeg,image/png" required>
                                <small class="text-muted">Önerilen boyut: 85mm x 118mm (A7 boyutu)</small>
                            </div>
                            <button type="submit" name="qr_arkaplan_yukle" class="btn btn-primary">Arka Plan Yükle</button>
                        </form>
                        
                        <?php if(!empty($arkaplan_resmi) && file_exists('../uploads/'.$arkaplan_resmi)): ?>
                        <div class="mt-3">
                            <p>Mevcut Arka Plan:</p>
                            <img src="../uploads/<?php echo $arkaplan_resmi; ?>?v=<?php echo time(); ?>" 
                                 alt="QR Arka Plan" 
                                 class="img-thumbnail" 
                                 style="max-width: 200px;">
                            
                            <form action="" method="POST" class="mt-2">
                                <button type="submit" name="qr_arkaplan_sil" class="btn btn-danger" 
                                       onclick="return confirm('Arka plan görselini silmek istediğinize emin misiniz?')">
                                    <i class="fas fa-trash"></i> Arka Planı Sil
                                </button>
                            </form>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Toplu yazdırma fonksiyonunu güncelleyelim -->
                <div class="action-buttons no-print mb-4">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#masaEkleModal">
                        <i class="fas fa-plus"></i> Yeni Masa Ekle
                    </button>
                    <button type="button" class="btn btn-success" onclick="printAllQRCodes()">
                        <i class="fas fa-print"></i> Tüm QR Kodları Yazdır
                    </button>
                </div>
                
                <!-- Masalar Listesi -->
                <div class="row">
                    <?php
                    $stmt = $conn->query("SELECT * FROM masalar ORDER BY masa_no");
                    while($masa = $stmt->fetch(PDO::FETCH_ASSOC)):
                        // HTTP veya HTTPS durumunu otomatik algıla
                        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' ? 'https' : 'http';
                        $qr_url = "$protocol://{$_SERVER['HTTP_HOST']}/?masa=" . $masa['benzersiz_kod'];
                        
                        // QR kodu için alternatif API
                        $qr_image_url = "https://api.qrserver.com/v1/create-qr-code/?size=300x300&data=" . urlencode($qr_url);
                        
                        // Debug için
                        echo "<!-- QR URL: " . $qr_url . " -->";
                        echo "<!-- QR Image URL: " . $qr_image_url . " -->";
                    ?>
                    <div class="col-md-4 col-lg-3 mb-3">
                        <div class="card masa-card">
                            <div class="card-header d-flex justify-content-between align-items-center no-print">
                                <h5 class="mb-0">Masa #<?php echo $masa['masa_no']; ?></h5>
                                <div class="action-buttons">
                                    <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#masaDuzenleModal<?php echo $masa['id']; ?>">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    <a href="qr.php?sil=<?php echo $masa['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Bu masayı silmek istediğinize emin misiniz?')">
                                        <i class="fas fa-trash"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="card-body text-center">
                                <div class="print-only text-center mb-3">
                                    <h4>Masa #<?php echo $masa['masa_no']; ?></h4>
                                    <?php if($masa['masa_adi']): ?>
                                        <h5><?php echo $masa['masa_adi']; ?></h5>
                                    <?php endif; ?>
                                </div>
                                
                                <img src="<?php echo $qr_image_url; ?>" alt="QR Kod" class="img-fluid qr-image">
                                
                                <?php if($masa['masa_adi']): ?>
                                    <p class="card-text mt-2 no-print"><strong><?php echo $masa['masa_adi']; ?></strong></p>
                                <?php endif; ?>
                                
                                <?php if($masa['masa_aciklama']): ?>
                                    <p class="card-text text-muted small no-print"><?php echo $masa['masa_aciklama']; ?></p>
                                <?php endif; ?>
                                
                                <div class="mt-3 no-print">
                                    <button class="btn btn-sm btn-success" onclick="printQRCode(<?php echo $masa['id']; ?>)">
                                        <i class="fas fa-print"></i> Yazdır / İndir
                                    </button>
                                </div>
                            </div>
                            <div class="card-footer text-center print-only">
                                <p>Menüyü görmek için QR kodu tarayın</p>
                                <p><?php echo $_SERVER['HTTP_HOST']; ?></p>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Masa Düzenleme Modal -->
                    <div class="modal fade" id="masaDuzenleModal<?php echo $masa['id']; ?>" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">Masa Düzenle</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                                </div>
                                <form method="POST" action="">
                                    <div class="modal-body">
                                        <input type="hidden" name="id" value="<?php echo $masa['id']; ?>">
                                        <div class="mb-3">
                                            <label for="masa_no" class="form-label">Masa Numarası</label>
                                            <input type="number" class="form-control" id="masa_no" name="masa_no" value="<?php echo $masa['masa_no']; ?>" required>
                                        </div>
                                        <div class="mb-3">
                                            <label for="masa_adi" class="form-label">Masa Adı (Opsiyonel)</label>
                                            <input type="text" class="form-control" id="masa_adi" name="masa_adi" value="<?php echo $masa['masa_adi']; ?>">
                                        </div>
                                        <div class="mb-3">
                                            <label for="masa_aciklama" class="form-label">Açıklama (Opsiyonel)</label>
                                            <textarea class="form-control" id="masa_aciklama" name="masa_aciklama" rows="2"><?php echo $masa['masa_aciklama']; ?></textarea>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                        <button type="submit" name="masa_guncelle" class="btn btn-primary">Güncelle</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endwhile; ?>
                </div>
                
                <?php 
                $stmt = $conn->query("SELECT COUNT(*) as total FROM masalar");
                $result = $stmt->fetch(PDO::FETCH_ASSOC);
                if($result['total'] == 0):
                ?>
                <div class="alert alert-info no-print">
                    Henüz masa eklenmemiş. Yeni bir masa eklemek için yukarıdaki butonu kullanabilirsiniz.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Masa Ekleme Modal -->
    <div class="modal fade" id="masaEkleModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Yeni Masa Ekle</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Kapat"></button>
                </div>
                <form method="POST" action="">
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="masa_no" class="form-label">Masa Numarası</label>
                            <input type="number" class="form-control" id="masa_no" name="masa_no" required>
                        </div>
                        <div class="mb-3">
                            <label for="masa_adi" class="form-label">Masa Adı (Opsiyonel)</label>
                            <input type="text" class="form-control" id="masa_adi" name="masa_adi">
                            <small class="text-muted">Örn: VIP Masa, Bahçe Masası 1</small>
                        </div>
                        <div class="mb-3">
                            <label for="masa_aciklama" class="form-label">Açıklama (Opsiyonel)</label>
                            <textarea class="form-control" id="masa_aciklama" name="masa_aciklama" rows="2"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                        <button type="submit" name="masa_ekle" class="btn btn-primary">Ekle</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });
    });
    </script>
</body>
</html> 