<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    die('Yetkisiz erişim');
}

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $kaynak_id = $_POST['kaynak_id'];
    $yeni_ad = $_POST['yeni_ad'];
    
    try {
        // Kaynak ürünü al
        $stmt = $conn->prepare("SELECT * FROM urunler WHERE id = ?");
        $stmt->execute([$kaynak_id]);
        $kaynak_urun = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($kaynak_urun) {
            // Yeni resim adı oluştur
            $yeni_resim = '';
            if($kaynak_urun['resim']) {
                $uzanti = pathinfo($kaynak_urun['resim'], PATHINFO_EXTENSION);
                $yeni_resim = uniqid() . '.' . $uzanti;
                copy('../uploads/' . $kaynak_urun['resim'], '../uploads/' . $yeni_resim);
            }
            
            // Yeni ürünü ekle
            $stmt = $conn->prepare("INSERT INTO urunler (kategori_id, urun_adi, fiyat, aciklama, resim, stok_durumu, populer) 
                                  VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $kaynak_urun['kategori_id'],
                $yeni_ad,
                $kaynak_urun['fiyat'],
                $kaynak_urun['aciklama'],
                $yeni_resim,
                $kaynak_urun['stok_durumu'],
                $kaynak_urun['populer']
            ]);
            
            header('Location: urunler.php?mesaj=kopyalandi');
        }
    } catch(PDOException $e) {
        header('Location: urunler.php?mesaj=hata');
    }
} 