<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    die(json_encode(['success' => false, 'message' => 'Yetkisiz erişim']));
}

$data = json_decode(file_get_contents('php://input'), true);
$urun_ids = $data['urun_ids'] ?? [];

if(empty($urun_ids)) {
    die(json_encode(['success' => false, 'message' => 'Ürün seçilmedi']));
}

try {
    foreach($urun_ids as $id) {
        // Ürün resmini al ve sil
        $stmt = $conn->prepare("SELECT resim FROM urunler WHERE id = ?");
        $stmt->execute([$id]);
        $urun = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if($urun['resim'] && file_exists('../uploads/' . $urun['resim'])) {
            unlink('../uploads/' . $urun['resim']);
        }
        
        // Ürünü sil
        $stmt = $conn->prepare("DELETE FROM urunler WHERE id = ?");
        $stmt->execute([$id]);
    }
    
    echo json_encode(['success' => true]);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
} 