<?php
session_start();
require_once 'auth.php';
require_once '../config/db.php';

if(!isset($_SESSION['admin'])) {
    header("Location: login.php");
    exit;
}

// Ürün Ekleme
if(isset($_POST['urun_ekle'])) {
    $kategori_id = $_POST['kategori_id'];
    $urun_adi = $_POST['urun_adi'];
    $fiyat = $_POST['fiyat'];
    $aciklama = $_POST['aciklama'];
    $stok_durumu = $_POST['stok_durumu'];
    $populer = isset($_POST['populer']) ? 1 : 0;
    
    // Alerjen değerlerini al
    $gluten = isset($_POST['gluten']) ? 1 : 0;
    $sut = isset($_POST['sut']) ? 1 : 0;
    $soya = isset($_POST['soya']) ? 1 : 0;
    $yumurta = isset($_POST['yumurta']) ? 1 : 0;
    
    // Resim yükleme
    $resim = '';
    
    // Uploads klasörünü kontrol et ve oluştur
    $uploads_dir = '../uploads/';
    if (!file_exists($uploads_dir)) {
        mkdir($uploads_dir, 0777, true);
    }
    
    if(isset($_FILES['resim'])) {
        error_log('Dosya yükleme bilgileri: ' . print_r($_FILES['resim'], true));
        
        if($_FILES['resim']['error'] == 0) {
            $izin_verilen_uzantilar = array('jpg', 'jpeg', 'png');
            $dosya_uzantisi = strtolower(pathinfo($_FILES['resim']['name'], PATHINFO_EXTENSION));
            
            if(in_array($dosya_uzantisi, $izin_verilen_uzantilar)) {
                $yeni_isim = uniqid();
                $hedef_yol = $uploads_dir . $yeni_isim;
                
                // GD kütüphanesi kontrolü
                if (!extension_loaded('gd')) {
                    error_log('GD kütüphanesi yüklü değil!');
                    // GD yoksa direkt orijinal dosyayı kaydet
                    if(move_uploaded_file($_FILES['resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                        $resim = $yeni_isim . '.' . $dosya_uzantisi;
                        error_log('GD olmadığı için orijinal dosya yüklendi: ' . $resim);
                    }
                } else {
                    // Orijinal resmi yükle
                    if(move_uploaded_file($_FILES['resim']['tmp_name'], $hedef_yol . '.' . $dosya_uzantisi)) {
                        error_log('Orijinal dosya başarıyla yüklendi: ' . $hedef_yol . '.' . $dosya_uzantisi);
                        
                        // WebP'ye dönüştür
                        $kaynak_resim = null;
                        
                        // Kaynak resmi yükle
                        if($dosya_uzantisi == 'jpg' || $dosya_uzantisi == 'jpeg') {
                            $kaynak_resim = @imagecreatefromjpeg($hedef_yol . '.' . $dosya_uzantisi);
                            error_log('JPEG/JPG dosyası yükleme denemesi');
                        } else if($dosya_uzantisi == 'png') {
                            $kaynak_resim = @imagecreatefrompng($hedef_yol . '.' . $dosya_uzantisi);
                            error_log('PNG dosyası yükleme denemesi');
                        }
                        
                        if($kaynak_resim) {
                            error_log('Kaynak resim başarıyla oluşturuldu');
                            // WebP olarak kaydet
                            if(imagewebp($kaynak_resim, $hedef_yol . '.webp', 80)) {
                                error_log('WebP dönüşümü başarılı: ' . $hedef_yol . '.webp');
                                
                                // Belleği temizle
                                imagedestroy($kaynak_resim);
                                
                                // Orijinal dosyayı sil
                                if(unlink($hedef_yol . '.' . $dosya_uzantisi)) {
                                    error_log('Orijinal dosya silindi');
                                } else {
                                    error_log('Orijinal dosya silinemedi');
                                }
                                
                                // Veritabanı için WebP dosya adını kaydet
                                $resim = $yeni_isim . '.webp';
                            } else {
                                error_log('WebP dönüşümü başarısız. PHP hatası: ' . error_get_last()['message']);
                                // WebP dönüşümü başarısız olursa orijinal dosyayı kullan
                                $resim = $yeni_isim . '.' . $dosya_uzantisi;
                            }
                        } else {
                            error_log('Kaynak resim oluşturulamadı. PHP hatası: ' . error_get_last()['message']);
                            $resim = $yeni_isim . '.' . $dosya_uzantisi;
                        }
                    } else {
                        error_log('Dosya yükleme hatası: ' . error_get_last()['message']);
                    }
                }
            } else {
                error_log('Geçersiz dosya uzantısı: ' . $dosya_uzantisi);
            }
        } else {
            error_log('Dosya yükleme hatası kodu: ' . $_FILES['resim']['error']);
        }
    }
    
    $balik = isset($_POST['balik']) ? 1 : 0;
    $yerfistigi = isset($_POST['yerfistigi']) ? 1 : 0;
    $kabuklular = isset($_POST['kabuklular']) ? 1 : 0;
    
    $stmt = $conn->prepare("INSERT INTO urunler (kategori_id, urun_adi, fiyat, aciklama, resim, stok_durumu, populer, gluten, sut, soya, yumurta, balik, yerfistigi, kabuklular) 
                           VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$kategori_id, $urun_adi, $fiyat, $aciklama, $resim, $stok_durumu, $populer, $gluten, $sut, $soya, $yumurta, $balik, $yerfistigi, $kabuklular]);
    header("Location: urunler.php?mesaj=eklendi");
}

// Ürün Silme
if(isset($_GET['sil'])) {
    $id = $_GET['sil'];
    // Önce resmi sil
    $stmt = $conn->prepare("SELECT resim FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $urun = $stmt->fetch(PDO::FETCH_ASSOC);
    if($urun['resim'] && file_exists('../uploads/' . $urun['resim'])) {
        unlink('../uploads/' . $urun['resim']);
    }
    // Sonra ürünü sil
    $stmt = $conn->prepare("DELETE FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    header("Location: urunler.php?mesaj=silindi");
}

// Ürün Kopyalama
if(isset($_GET['kopya'])) {
    $id = $_GET['kopya'];
    
    // Ürün bilgilerini al
    $stmt = $conn->prepare("SELECT * FROM urunler WHERE id = ?");
    $stmt->execute([$id]);
    $urun = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if($urun) {
        // Resim işleme
        $yeni_resim = '';
        if($urun['resim'] && file_exists('../uploads/' . $urun['resim'])) {
            $uzanti = pathinfo($urun['resim'], PATHINFO_EXTENSION);
            $yeni_resim = uniqid() . '.' . $uzanti;
            copy('../uploads/' . $urun['resim'], '../uploads/' . $yeni_resim);
        }
        
        // Yeni ürün oluştur
        $stmt = $conn->prepare("INSERT INTO urunler (kategori_id, urun_adi, fiyat, aciklama, resim, stok_durumu, populer, gluten, sut, soya, yumurta) 
                               VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $urun['kategori_id'],
            $urun['urun_adi'] . ' (Kopya)',
            $urun['fiyat'],
            $urun['aciklama'],
            $yeni_resim,
            $urun['stok_durumu'],
            $urun['populer'],
            $urun['gluten'],
            $urun['sut'],
            $urun['soya'],
            $urun['yumurta']
        ]);
        
        header("Location: urunler.php?mesaj=kopyalandi");
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ürünler - QR Menü</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #343a40;
            padding-top: 20px;
            z-index: 1000;
        }
        .sidebar a {
            color: white;
            text-decoration: none;
            padding: 10px 20px;
            display: block;
        }
        .sidebar a:hover {
            background: #495057;
        }
        .content {
            padding: 20px;
        }
        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                top: 0;
                left: -250px;
                width: 250px;
                height: 100%;
                transition: left 0.3s ease;
                z-index: 1000;
            }
            .sidebar.show {
                left: 0;
            }
            #sidebarClose {
                display: inline; /* Mobilde göster */
            }
        }
        @media (min-width: 769px) {
            #sidebarClose {
                display: none; /* Masaüstünde gizle */
            }
        }
        .urun-resim {
            max-width: 100px;
            max-height: 100px;
        }
        .collapse {
            transition: all 0.3s ease;
        }
        
        .btn-close {
            opacity: 0.5;
        }
        
        .btn-close:hover {
            opacity: 1;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <button class="btn btn-primary d-md-none" id="sidebarToggle">Menüyü Göster</button>
        <div class="row">
            <div class="col-md-2 sidebar" id="sidebar">
                <h3 class="text-white text-center mb-4">QR Menü Admin <span id="sidebarClose" style="cursor: pointer; color: white;">&times;</span></h3>
                <a href="index.php"><i class="fas fa-home"></i> Ana Sayfa</a>
                <a href="kategoriler.php"><i class="fas fa-list"></i> Kategoriler</a>
                <a href="urunler.php"><i class="fas fa-utensils"></i> Ürünler</a>
                <a href="sikayet.php"><i class="fas fa-comment-alt"></i> Şikayetler</a>
                <a href="qr.php"><i class="fas fa-qrcode"></i> QR Kodlar</a>
                <a href="ayarlar.php"><i class="fas fa-cog"></i> Ayarlar</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Çıkış</a>
            </div>
            
            <div class="col-md-10 content" id="contentArea">
                <h2 class="mb-4">Ürünler</h2>
                
                <?php if(isset($_GET['mesaj'])): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php 
                        $mesaj = $_GET['mesaj'];
                        if($mesaj == 'eklendi') echo "Ürün başarıyla eklendi.";
                        else if($mesaj == 'silindi') echo "Ürün başarıyla silindi.";
                        else if($mesaj == 'guncellendi') echo "Ürün başarıyla güncellendi.";
                        else if($mesaj == 'kopyalandi') echo "Ürün başarıyla kopyalandı.";
                        ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Kapat"></button>
                    </div>
                <?php endif; ?>

                <!-- Yeni Ürün Ekleme Butonu -->
                <div class="mb-4">
                    <button class="btn btn-primary" type="button" data-bs-toggle="collapse" data-bs-target="#urunEkleForm">
                        <i class="fas fa-plus"></i> Yeni Ürün Ekle
                    </button>
                </div>

                <!-- Ürün Ekleme Formu (Collapse) -->
                <div class="collapse mb-4" id="urunEkleForm">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h5 class="card-title mb-0">Yeni Ürün Ekle</h5>
                                <button type="button" class="btn-close" data-bs-toggle="collapse" data-bs-target="#urunEkleForm"></button>
                            </div>
                            <form method="POST" action="" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label for="kategori_id" class="form-label">Kategori</label>
                                    <select class="form-control" id="kategori_id" name="kategori_id" required>
                                        <?php
                                        $stmt = $conn->query("SELECT * FROM kategoriler ORDER BY kategori_adi");
                                        while($kategori = $stmt->fetch(PDO::FETCH_ASSOC)):
                                        ?>
                                        <option value="<?php echo $kategori['id']; ?>"><?php echo $kategori['kategori_adi']; ?></option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label for="urun_adi" class="form-label">Ürün Adı</label>
                                    <input type="text" class="form-control" id="urun_adi" name="urun_adi" required>
                                </div>
                                <div class="mb-3">
                                    <label for="fiyat" class="form-label">Fiyat</label>
                                    <input type="number" step="0.01" class="form-control" id="fiyat" name="fiyat" required>
                                </div>
                                <div class="mb-3">
                                    <label for="aciklama" class="form-label">Açıklama</label>
                                    <textarea class="form-control" id="aciklama" name="aciklama" rows="3"></textarea>
                                </div>
                                <div class="mb-3">
                                    <label for="stok_durumu" class="form-label">Stok Durumu</label>
                                    <select class="form-control" id="stok_durumu" name="stok_durumu" required>
                                        <option value="1">Stokta Var</option>
                                        <option value="0">Stokta Yok</option>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="populer" name="populer">
                                        <label class="form-check-label" for="populer">
                                            Popüler Ürün
                                        </label>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <label for="resim" class="form-label">Ürün Resmi</label>
                                    <input type="file" class="form-control" id="resim" name="resim">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Gıda Alerjenleri</label>
                                    <div class="d-flex gap-3 flex-wrap">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="gluten" name="gluten">
                                            <label class="form-check-label" for="gluten">
                                                <i class="fas fa-bread-slice"></i> Gluten
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="sut" name="sut">
                                            <label class="form-check-label" for="sut">
                                                <i class="fas fa-glass-whiskey"></i> Süt
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="soya" name="soya">
                                            <label class="form-check-label" for="soya">
                                                <i class="fas fa-seedling"></i> Soya
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="yumurta" name="yumurta">
                                            <label class="form-check-label" for="yumurta">
                                                <i class="fas fa-egg"></i> Yumurta
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="balik" name="balik">
                                            <label class="form-check-label" for="balik">
                                                <i class="fas fa-fish"></i> Balık
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="yerfistigi" name="yerfistigi">
                                            <label class="form-check-label" for="yerfistigi">
                                                <i class="fas fa-leaf"></i> Yer Fıstığı
                                            </label>
                                        </div>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="kabuklular" name="kabuklular">
                                            <label class="form-check-label" for="kabuklular">
                                                <i class="fas fa-water"></i> Kabuklular
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <button type="submit" name="urun_ekle" class="btn btn-primary">Ekle</button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Toplu İşlem Butonları -->
                <div class="mb-3">
                    <button type="button" class="btn btn-danger" id="topluSilBtn" style="display: none;">
                        <i class="fas fa-trash"></i> Seçilenleri Sil
                    </button>
                </div>

                <!-- Ürünler Tablosu -->
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Resim</th>
                                <th>Ürün Adı</th>
                                <th>Fiyat</th>
                                <th>Açıklama</th>
                                <th>Stok Durumu</th>
                                <th>İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $stmt = $conn->query("SELECT * FROM urunler ORDER BY id DESC");
                            while($urun = $stmt->fetch(PDO::FETCH_ASSOC)):
                            ?>
                            <tr>
                                <td><?php echo $urun['id']; ?></td>
                                <td>
                                    <?php if($urun['resim']): ?>
                                        <img src="../uploads/<?php echo $urun['resim']; ?>" class="urun-resim" alt="<?php echo htmlspecialchars($urun['urun_adi']); ?>">
                                    <?php else: ?>
                                        <img src="../uploads/default.jpg" class="urun-resim" alt="Varsayılan Resim">
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $urun['urun_adi']; ?></td>
                                <td><?php echo $urun['fiyat']; ?> TL</td>
                                <td><?php echo nl2br(htmlspecialchars(substr($urun['aciklama'], 0, 100))); ?><?php echo strlen($urun['aciklama']) > 100 ? '...' : ''; ?></td>
                                <td><?php echo $urun['stok_durumu'] ? 'Stokta Var' : 'Stokta Yok'; ?></td>
                                <td>
                                    <a href="urun_duzenle.php?id=<?php echo $urun['id']; ?>" class="btn btn-warning btn-sm">Düzenle</a>
                                    <a href="urunler.php?sil=<?php echo $urun['id']; ?>" class="btn btn-danger btn-sm">Sil</a>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Kopyalama Modal -->
                <div class="modal fade" id="kopyalaModal" tabindex="-1">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Ürün Kopyala</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <form id="kopyalaForm" method="POST" action="urun_kopyala.php">
                                    <input type="hidden" name="kaynak_id" id="kaynak_id">
                                    <div class="mb-3">
                                        <label for="yeni_ad" class="form-label">Yeni Ürün Adı</label>
                                        <input type="text" class="form-control" id="yeni_ad" name="yeni_ad" required>
                                    </div>
                                </form>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                <button type="submit" form="kopyalaForm" class="btn btn-primary">Kopyala</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Sidebar toggle
        document.getElementById('sidebarToggle').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('show');
        });

        // Sidebar close
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.getElementById('sidebar').classList.remove('show');
        });

        // Sağ tarafta boş alana tıklanınca sidebar'ı kapat
        document.getElementById('contentArea').addEventListener('click', function(event) {
            if (document.getElementById('sidebar').classList.contains('show') && event.target.id !== 'sidebarToggle') {
                document.getElementById('sidebar').classList.remove('show');
            }
        });

        // Toplu seçim işlemleri
        const tumunuSec = document.getElementById('tumunuSec');
        const urunCheckboxlar = document.querySelectorAll('.urun-sec');
        const topluSilBtn = document.getElementById('topluSilBtn');
        
        tumunuSec.addEventListener('change', function() {
            urunCheckboxlar.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            topluSilBtn.style.display = this.checked ? 'inline-block' : 'none';
        });
        
        urunCheckboxlar.forEach(checkbox => {
            checkbox.addEventListener('change', function() {
                const seciliSayisi = document.querySelectorAll('.urun-sec:checked').length;
                topluSilBtn.style.display = seciliSayisi > 0 ? 'inline-block' : 'none';
                tumunuSec.checked = seciliSayisi === urunCheckboxlar.length;
            });
        });
        
        // Toplu silme işlemi
        topluSilBtn.addEventListener('click', function() {
            if(confirm('Seçili ürünleri silmek istediğinizden emin misiniz?')) {
                const seciliUrunler = Array.from(document.querySelectorAll('.urun-sec:checked'))
                                         .map(cb => cb.value);
                
                fetch('urun_toplu_sil.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        urun_ids: seciliUrunler
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if(data.success) {
                        location.reload();
                    } else {
                        alert('Bir hata oluştu: ' + data.message);
                    }
                });
            }
        });
        
        // Kopyalama işlemleri
        const kopyalaModal = new bootstrap.Modal(document.getElementById('kopyalaModal'));
        
        document.querySelectorAll('.kopyalaBtn').forEach(btn => {
            btn.addEventListener('click', function() {
                const id = this.dataset.id;
                const ad = this.dataset.ad;
                
                document.getElementById('kaynak_id').value = id;
                document.getElementById('yeni_ad').value = ad + ' - Kopya';
                
                kopyalaModal.show();
            });
        });
    });
    </script>
</body>
</html> 