<?php
require_once 'config/db.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lisans Ofisi QR Menü Sistemi - Canlı Demo</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }
        .demo-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        .mobile-frame {
            background-color: white;
            border-radius: 40px;
            padding: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.15);
            max-width: 360px;
            margin: 0 auto;
            border: 1px solid #e0e0e0;
        }
        .mobile-screen {
            background-color: white;
            border-radius: 25px;
            overflow: hidden;
            height: 650px;
            position: relative;
        }
        .mobile-iframe {
            width: calc(100% + 10px); /* Sağa kaydır */
            height: 100%;
            border: none;
            margin-left: -5px; /* Dengeleme için */
        }
        .mobile-notch {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 150px;
            height: 20px;
            background-color: #f0f0f0;
            border-bottom-left-radius: 15px;
            border-bottom-right-radius: 15px;
            z-index: 10;
            border: 1px solid #e0e0e0;
            border-top: none;
        }
        .info-container {
            padding: 20px;
            background-color: white;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
            height: 100%;
        }
        .info-title {
            color: #0056b3;
            font-weight: 700;
            margin-bottom: 20px;
        }
        .info-description {
            color: #555;
            line-height: 1.6;
            margin-bottom: 25px;
        }
        .qr-container {
            text-align: center;
            margin: 30px 0;
        }
        .qr-code {
            max-width: 200px;
            margin: 0 auto;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
            border-radius: 10px;
            padding: 10px;
            background-color: white;
        }
        .contact-buttons {
            display: flex;
            gap: 15px;
            margin-top: 30px;
            justify-content: center;
        }
        .contact-btn {
            padding: 10px 25px;
            border-radius: 50px;
            font-weight: 600;
            text-decoration: none;
            display: flex;
            align-items: center;
            gap: 10px;
            transition: all 0.3s ease;
            box-shadow: 0 3px 8px rgba(0,0,0,0.1);
        }
        .whatsapp-btn {
            background-color: #25D366;
            color: white;
        }
        .whatsapp-btn:hover {
            background-color: #1faa52;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 12px rgba(0,0,0,0.15);
        }
        .phone-btn {
            background-color: #0056b3;
            color: white;
        }
        .phone-btn:hover {
            background-color: #003d80;
            color: white;
            transform: translateY(-2px);
            box-shadow: 0 5px 12px rgba(0,0,0,0.15);
        }
        .footer {
            text-align: center;
            color: #777;
            font-size: 14px;
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #eee;
        }
        @media (max-width: 991.98px) {
            .order-mobile-1 {
                order: 2;
                margin-top: 40px;
            }
            .order-mobile-2 {
                order: 1;
            }
        }
    </style>
</head>
<body>
    <div class="demo-container">
        <div class="row">
            <div class="col-lg-5 mobile-container order-mobile-1">
                <div class="mobile-frame">
                    <div class="mobile-screen">
                        <div class="mobile-notch"></div>
                        <iframe src="https://v6.lisansofisi.com/" class="mobile-iframe" title="QR Menü Demo"></iframe>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-7 order-mobile-2">
                <div class="info-container">
                    <h1 class="info-title">Lisans Ofisi Yeni Nesil Dijital QR Menü!</h1>
                    
                    <p class="info-description">
                        Yeni nesil Dijital Qr Menü yazılımı ile artık herşey eskisinden daha pratik. Ayrıca hiç olmadığı kadar modern ve hızlı!
                    </p>
                    
                    <div class="qr-container">
                        <p class="mb-3">Dilerseniz telefonunuzdan aşağıdaki kodu okutarakta örnek menüyü inceleyebilirsiniz.</p>
                        
                        <?php
                        // QR kod oluşturma için URL
                        $qr_url = "https://v6.lisansofisi.com/";
                        $qr_image_url = "https://api.qrserver.com/v1/create-qr-code/?size=200x200&data=" . urlencode($qr_url);
                        ?>
                        
                        <img src="<?php echo $qr_image_url; ?>" alt="QR Kod" class="qr-code">
                    </div>
                    
                    <p class="text-center info-description">
                        Sizde Lisans Ofisi ile hizmet almak isterseniz bize ulaşın.
                    </p>
                    
                    <div class="contact-buttons">
                        <a href="https://wa.me/903129110559" class="contact-btn whatsapp-btn">
                            <i class="fab fa-whatsapp"></i> WhatsApp
                        </a>
                        <a href="tel:+903129110559" class="contact-btn phone-btn">
                            <i class="fas fa-phone"></i> Ara
                        </a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="footer">
            &copy; <?php echo date('Y'); ?> Lisans Ofisi - Tüm Hakları Saklıdır.
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 