<?php
require_once 'config/db.php';

header('Content-Type: application/json');

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $musteri_adi = $_POST['musteri_adi'] ?? '';
    $email = $_POST['email'] ?? '';
    $konu = $_POST['konu'] ?? '';
    $mesaj = $_POST['mesaj'] ?? '';

    if(empty($musteri_adi) || empty($email) || empty($konu) || empty($mesaj)) {
        echo json_encode(['success' => false, 'message' => 'Tüm alanları doldurunuz.']);
        exit;
    }

    if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Geçerli bir e-posta adresi giriniz.']);
        exit;
    }

    try {
        $stmt = $conn->prepare("INSERT INTO sikayetler (musteri_adi, email, konu, mesaj) VALUES (?, ?, ?, ?)");
        $stmt->execute([$musteri_adi, $email, $konu, $mesaj]);
        
        echo json_encode(['success' => true, 'message' => 'Geri bildiriminiz başarıyla gönderildi.']);
    } catch(PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Bir hata oluştu: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Geçersiz istek metodu.']);
}
?> 